<?php

class PageData {
	
	//---------------------------------------------------------
	//  コントロール設定
	//---------------------------------------------------------
	
	public static function control(): array {
		
		// コントロール設定を返す
		return [true, false, 'Header', 'Footer'];
		
	}
	
	//---------------------------------------------------------
	//  ページ情報編集メニュー表示
	//---------------------------------------------------------
	
	public static function execute(): void {
		
		// DBクラスを取得
		$db = $GLOBALS['object']['db'];
		
		// テンプレートクラスを取得
		$tmpl = $GLOBALS['object']['tmpl'];
		
		// メインDB名を取得
		$mainDB = $GLOBALS['mainDB'];
		
		////////////////////////////////////////////////////////////
		
		// DBが存在しない時は終了
		if (!$db->exists($mainDB)) {
			return;
		}
		
		////////////////////////////////////////////////////////////
		
		// URLパスを設定
		$vars1['path'] = PATH;
		
		// URLパスディレクトリを設定
		$vars1['pathDir'] = PATH_DIR;
		
		// タイプを取得
		$type = $GLOBALS['args'][1] ?? 'page';
		
		// オプションを取得
		$opt = $GLOBALS['args'][2] ?? '0';
		
		// テーブル名を取得
		$table = $GLOBALS['config']['table'][$type];
		
		// オプションを変数に設定
		$vars1['opt'] = $opt;
		$vars1['type'] = $type;
		
		// エラーメッセージを初期化
		$error = '';
		
		// メニューリンクを取得
		$vars1['contentFilter'] = Header::createFilterLink('page_data');
		
		////////////////////////////////////////////////////////////
		
		// CSV編集モードの時
		if ($opt === 'csv') {
			
			// リクエストメソッドがPOSTの時は変更処理
			if ($_SERVER['REQUEST_METHOD'] === 'POST') {
				self::writeCsv($db, $table);
			}
			
			// データを出力
			self::viewCsv($tmpl, $db, $table, $vars1);
			
			// 終了
			return;
			
		}
		
		// リクエストメソッドがPOSTの時は変更処理
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
			$error = self::write($db, $table);
		}
		
		////////////////////////////////////////////////////////////
		
		// SQLとリンクを取得
		[$query, $vars2] = self::createMoveLink($db, $table, $vars1);
		
		// ヘッダー,メイン,フッター テンプレートを取得
		[$head, $body, $foot, $allView] = $tmpl->read('page_data.htm');
		
		// 改行を末尾に追記
		$foot .= "\n";
		
		// メインHTML
		$html = '';
		
		// カウンター変数
		$i = 0;
		
		// ID配列
		$ids = [];
		
		// クエリーを実行
		$result = $db->query($query);
		
		// データが存在する時
		while ($rec = $db->fetch($result)) {
			
			// 色分け用class属性を設定
			$rec['tr'] = ($i % 2 === 0) ? 1 : 2;
			
			// 編集用IDを設定
			$rec['i'] = $i;
			
			// メインHTMLに追記
			$html .= $tmpl->res($body, $rec);
			
			// カウンタを1増加
			++$i;
			
			// IDを配列に格納
			$ids[] = $rec['id'];
			
		}
		
		// 開始＆終了Noを取得
		$vars2['currentId'] = ($ids) ? $ids[0] . ' ～ ' . array_pop($ids) : 'no data';
		
		// ヘッダーHTMLを出力
		$tmpl->show($head, $vars2);
		
		// メインHTMLを出力
		echo $error , $html;
		
		// フッターHTMLを出力
		$tmpl->show($foot);
		
		// 全件表示ではない時
		if ($opt !== 'all' and $ids) {
			$GLOBALS['args']['contentAll'] = $tmpl->res($allView, $vars2);
		}
		
	}
	
	//---------------------------------------------------------
	//  リンク取得
	//---------------------------------------------------------
	
	private static function createMoveLink(
			DB $db, 
			string $table, 
			array $vars
		): array {
		
		// 全件表示の時
		if ($vars['opt'] == 'all') {
			
			// クエリーを作成
			$query = "select * from $table order by id desc;";
			
			// 前何件へのリンクを設定
			$vars['prevLink'] = 'class="no_link"';
			
			// 次何件へのリンクを設定
			$vars['nextLink'] = 'class="no_link"';
			
			// SQLとリンクを返す
			return [$query, $vars];
			
		}
		
		// 変数を初期化
		$type = $vars['type'];
		$begin = $vars['opt'];
		$limit = 100;
		
		// クエリーを作成
		$selectCountQuery = "select count(*) as count from $table limit 1;";
		
		// クエリーを実行
		$count = $db->queryFetch($selectCountQuery, 'count');
		
		// 開始番号が0未満の時
		if ($begin < 0) {
			$begin = 0;
		}
		
		// 開始番号が総数以上の時
		elseif ($begin > $count) {
			$begin = $count;
		}
		
		// クエリーを作成
		$query = "select * from $table order by id desc limit $begin, $limit;";
		
		////////////////////////////////////////////////////////////
		
		// リンクを設定
		$link = 'href="' . PATH . "/page_data/$type/";
		
		// 開始番号を取得
		$prevId = $begin - $limit;
		
		// 開始番号が0未満の時
		if ($prevId < 0) {
			$prevId = 0;
		}
		
		// 次の開始番号を取得
		$nextId = $begin + $limit;
		
		// 開始番号が総数以上の時
		if ($nextId > $count) {
			$nextId = $count;
		}
		
		// 前何件へのリンクを設定
		$vars['prevLink'] = ($begin !== 0) ? $link . $prevId . '/"' : 'class="no_link"';
		
		// 次何件へのリンクを設定
		$vars['nextLink'] = ($nextId !== $count) ? $link . $nextId . '/"' : 'class="no_link"';
		
		// SQLとリンクを返す
		return [$query, $vars];
		
	}
	
	//---------------------------------------------------------
	//  CSV表示
	//---------------------------------------------------------
	
	private static function viewCsv(
			Template $tmpl, 
			DB $db, 
			string $table, 
			array $vars
		): void {
		
		// ヘッダー,メイン,フッター テンプレートを取得
		$html = $tmpl->read('page_data_csv.htm', false);
		
		// クエリーを作成
		$query = "select * from $table order by id;";
		
		// クエリーを実行
		$result = $db->query($query);
		
		// テンプレート変数を初期化
		$vars['csvText'] = '';
		
		// 変数を初期化
		$ids = [];
		
		// データが存在する時
		while ($rec = $db->fetch($result)) {
			
			// タイトルをエンコード
			$rec['title'] = self::encodeHTML($rec['title']);
			
			// データを変数に追記
			$vars['csvText'] .= $rec['id'] . ',' . $rec['url'] . ',' . $rec['title'] . "\n";
			
			// Noを配列に格納
			$ids[] = $rec['id'];
			
		}
		
		// 開始＆終了Noを取得
		$vars['currentId'] = ($ids) ? $ids[0] . ' ～ ' . array_pop($ids) : 'no data';
		
		// テンプレートを出力
		$tmpl->show($html, $vars);
		
	}
	
	//---------------------------------------------------------
	//  テーブル更新処理
	//---------------------------------------------------------
	
	private static function write(
			DB $db, 
			string $table
		): string {
		
		// エラーメッセージを初期化
		$error = '';
		
		// データが無い時は終了
		if (!isset($GLOBALS['args']['ids'])) {
			return $error;
		}
		
		// 送信データを取得
		$ids = $GLOBALS['args']['ids'];
		$urls = $GLOBALS['args']['urls'];
		$titles = $GLOBALS['args']['titles'];
		
		// トランザクション開始
		$db->begin();
		
		// データ編集ループ
		foreach ($ids as $id) {
			
			// 変更後の値を取得
			$url = $db->escape($urls[$id]);
			$title = $db->escape($titles[$id]);
			
			// データが存在しない時は次へ
			if (!$urls[$id] || !$titles[$id]) {
				$query = "delete from $table where id = $id;";
			}
			
			// データが存在する時
			else {
				
				// クエリーを作成
				$selectCountQuery = "select count(url) as count from $table where url = $url and id != $id limit 1;";
				
				// URLが重複している時は次へ
				if ($db->queryFetch($selectCountQuery, 'count')) {
					
					// エラーに追記
					$error .= "\n\t\t\t\t\t\t" . '<tr class="error_tr"><td>' . $id . '</td><td>&nbsp; ' . $urls[$id] . ' は既に存在しているURLです！</td></tr>';
					
					// 次へ
					continue;
					
				}
				
				// クエリーを作成
				$query = "update $table set url = $url, title = $title where id = $id;";
				
			}
			
			// クエリーを実行
			$db->query($query);
			
		}
		
		// トランザクション終了
		$db->commit();
		
		// データ領域開放
		$db->query('vacuum;');
		
		// 終了
		return $error;
		
	}
	
	//---------------------------------------------------------
	//  テーブル更新処理
	//---------------------------------------------------------
	
	private static function writeCsv(
			DB $db, 
			string $table
		): void {
		
		// 送信データを取得
		$csvText = $GLOBALS['args']['csv_text'];
		
		// \rを削除
		$csvText = str_replace("\r", '', $csvText);
		
		// 改行で分割
		$csv = explode("\n", $csvText);
		
		// レコード数を取得
		$count = count($csv);
		
		// トランザクション開始
		$db->begin();
		
		// クエリーを作成
		$deleteQuery = "delete from $table;";
		
		// クエリーを実行
		$db->query($deleteQuery);
		
		// データ編集ループ
		for ($i = 0; $i < $count; ++$i) {
			
			// データが存在しない時は次へ
			if (!$csv[$i]) {
				continue;
			}
			
			// レコードを分割する
			[$id, $url, $title] = explode(',', $csv[$i]);
			
			// データが欠損している時は次へ
			if (!$id || !$url || !$title) {
				continue;
			}
			
			// データをエスケープ
			$url = $db->escape($url);
			$title = $db->escape($title);
			
			// クエリーを作成
			$updateQuery = "insert into $table values($id, $url, $title);";
			
			// クエリーを実行
			$db->query($updateQuery);
			
		}
		
		// トランザクション終了
		$db->commit();
		
		// データ領域開放
		$db->query('vacuum;');
		
	}
	
	//---------------------------------------------------------
	//  HTML表示用に文字列をエンコード
	//---------------------------------------------------------
	
	private static function encodeHTML($str) {
		
		// 改行コード、タブを削除
		$str = str_replace(["\r", "\n", "\t"], '', $str);
		
		// 実体参照に変換
		$str = htmlspecialchars($str, ENT_QUOTES);
		$str = str_replace(',', '&#44;', $str);
		$str = str_replace('\\', '&#165;', $str);
		
		// 変換後の文字列を返す
		return $str;
		
	}
	
}

