<?php

class TimeHist {
	
	//---------------------------------------------------------
	//  分布グラフを表示
	//---------------------------------------------------------
	
	public static function show(): void {
		
		// データがない時は終了
		if (!count($GLOBALS['args']['months'])) {
			return;
		}
		
		// 変数を初期化
		$names = ['weekday', 'holiday'];
		$counts1 = ['weekday' => 0, 'holiday' => 0];
		$counts2 = [];
		$versions = [];
		$captions = ['weekday' => '時間別アクセス分布：平日', 'holiday' => '時間別アクセス分布：休日'];
		
		////////////////////////////////////////////////////////////
		
		// ループ
		foreach ($GLOBALS['args']['months'] as $m) {
			
			// カウント総数を加算 UU PV を分けて加算する
			$counts1['weekday'] += array_sum($GLOBALS['args']['weekday'][$m]);
			$counts1['holiday'] += array_sum($GLOBALS['args']['holiday'][$m]);
			
			// 時間ループ
			for ($i = 0; $i < 24; ++$i) {
				
				// 0埋めで2桁の数値を設定
				$h = str_pad($i, 2, '0', STR_PAD_LEFT);
				
				// カラム名を設定
				$h_uu = 'h' . $h . '_uu';
				
				// 配列数分ループ
				foreach ($names as $name) {
					
					// カウント数を取得
					$count = (int) $GLOBALS['args'][$name][$m][$h_uu];
					
					// 項目名を設定
					$version = 'h' . $h;
					
					// 未定義の時は0を設定
					if (!isset($counts2[$name][$version])) {
						$counts2[$name][$version] = 0;
					}
					
					// カウント数を設定
					$counts2[$name][$version] += $count;
					
					// バージョンを配列に追加（ソート用）
					if (!isset($versions[$name]) || !in_array($version, $versions[$name])) {
						$versions[$name][] = $version;
					}
					
				}
				
			}
			
		}
		
		////////////////////////////////////////////////////////////
		
		// テンプレートクラスを取得
		$tmpl = $GLOBALS['object']['tmpl'];
		
		// テンプレートを分割
		$body = $tmpl->read('time_hist.htm', false);
		
		// UA種別とOS種別を取得
		[$device, $os] = Controller::device();
		
		// PCフラグ
		$isPC = ($device === 3);
		
		////////////////////////////////////////////////////////////
		
		// 項目別にループ処理
		foreach ($counts1 as $key => $val) {
			
			// カウント最大値を取得
			$max = max($counts2[$key]);
			
			// データがない時は次へ
			if (!$max) {
				continue;
			}
			
			// 最大値から倍率を算出
			$n = ($isPC) ? (float) (180 / $max) : "calc(var(--px) / $max * ";
			
			// キャプションを設定
			$vars['caption'] = $captions[$key];
			
			// バージョン別にループ処理
			foreach ($versions[$key] as $version) {
				
				// カウント数を取得
				$count = $counts2[$key][$version];
				
				// 縦幅を算出
				$height = ($isPC) ? ($n * $count) . 'px' : $n . $count . ')';
				
				// 棒グラフを設定
				$bar = '<span class="bar_span" style="height:' . $height . ';"></span>';
				
				// 項目名を設定
				$vars[$version] = $count . $bar;
				
			}
			
			// テンプレートを出力
			$tmpl->show($body, $vars);
			
		}
		
	}
	
}

