<?php
/*
Plugin Name: Lunalys
Plugin URI: https://yuh-nagomi.jp/lunalys/
Description: マルチサイト対応のアクセス解析プラグインです。
Version: 5.0.2
Author: なごみ佑
Author URI: https://yuh-nagomi.jp/lunalys/
*/

// 管理画面の起動時にメニューを表示
add_action('init', 'LunalysPlugin::init');

// </head>付近に<script>を出力
add_action('wp_loaded', 'LunalysPlugin::addInHead');

// </body>付近に<noscript>を出力
add_action('wp_footer', 'LunalysPlugin::addInBody');

// <script>出力前に内容をリプレイス
add_filter('script_loader_tag', 'LunalysPlugin::replaceTag', 10, 2);

//==========================================================
//  Lunalys Plugin for WordPress
//==========================================================

// クラスを定義
class LunalysPlugin {
	
	//---------------------------------------------------------
	//  初期化
	//---------------------------------------------------------
	
	public static function init() {
		return new self();
	}
	
	//---------------------------------------------------------
	//  コンストラクタ
	//---------------------------------------------------------
	
	public function __construct() {
		
		// 管理者の時のみメニューを追加
		if (is_admin() && is_user_logged_in()) {
			add_action('admin_menu', [$this, 'addAdminMenu']);
		}
		
	}
	
	//---------------------------------------------------------
	//  メインメニューを表示
	//---------------------------------------------------------
	
	public function addAdminMenu() {
		
		add_menu_page(
			'Lunalys',              /* ページタイトル*/
			'Lunalys',              /* メニュータイトル */
			'manage_options',       /* 権限 */
			'lunalys-plugin',       /* スラッグ名 */
			[$this, 'showLunalys'], /* メニューに紐づく画面を描画するcallback関数 */
			'dashicons-analytics',  /* アイコン see: https://developer.wordpress.org/resource/dashicons/#awards */
			99                      /* 表示位置のオフセット */
		);
		
	}
	
	//---------------------------------------------------------
	//  メインメニューをタップした時に<iframe>を出力
	//---------------------------------------------------------
	
	public function showLunalys() {
		
		// 管理画面のURLを取得
		$php = plugins_url('analyzer/index.php', __FILE__);
		
		// JavaScriptのURLを取得
		$js = plugins_url('iframe.js', __FILE__);
		
		// <iframe>を出力
		echo '<iframe id="lunalys_iframe" style="width: 100%; height: 1px;" src="' . $php . '" sandbox="allow-popups allow-forms allow-scripts allow-top-navigation allow-same-origin"></iframe>';
		
		// <script>を出力
		wp_enqueue_script('lunalys-iframe', $js, array(), NULL, true);
		
	}
	
	//---------------------------------------------------------
	//  </head>付近に<script>を出力
	//---------------------------------------------------------
	
	public static function addInHead() {
		
		// 公開ページの時
		if (!is_admin() && $GLOBALS['pagenow'] !== 'wp-login.php') {
			
			// データ取得用URLを取得
			$js = plugins_url('analyzer/tracker.js', __FILE__);
			
			// <script>を出力
			wp_enqueue_script('lunalys', $js, array(), NULL, false);
			
		}
		
	}
	
	//---------------------------------------------------------
	//  </body>付近に<noscript>を出力
	//---------------------------------------------------------
	
	public static function addInBody() {
		
		// データ取得用URLを取得
		$php = plugins_url('analyzer/tracker.php', __FILE__);
		
		// プロトコルを取得
		$protocol = (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off') ? 'http' : 'https';
		
		// リクエストURLを絶対パスで取得
		$url = $protocol . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
		
		// 現在のブログIDを取得
		$blogId = get_current_blog_id();
		
		// <noscript>を出力
		echo <<<_HTML_

<noscript>
	<span style="visibility: hidden; position: absolute; top: 0; left: 0;">
		<img src="$php?act=img&site=$blogId&url=$url" width="1" height="1" alt="tracker">
	</span>
</noscript>

_HTML_;
		
	}
	
	//---------------------------------------------------------
	//  <script>出力前に内容をリプレイス
	//---------------------------------------------------------
	
	public static function replaceTag($tag, $handle) {
		
		// 対象以外の場合は何もしない
		if ($handle !== 'lunalys') {
			return $tag;
		}
		
		// 現在のブログIDを取得
		$blogId = get_current_blog_id();
		
		// グローバル変数
		global $wp_version;
		
		// WordPress本体のバージョンを取得
		$ver = explode('.', $wp_version);
		
		// intにキャスト
		$v0 = (int) $ver[0];
		$v1 = (int) $ver[1];
		
		// 処理
		$type = 0;
		
		// 5.0.0 以下
		if ($v0 <= 5) {
			$type = 0;
		}
		
		// 6.x.x
		elseif ($v0 === 6) {
			
			// 6.4.0 以上
			if ($v1 >= 4) {
				$type = 1;
			}
			
			// 6.4.0 未満
			else {
				$type = 0;
			}
			
		}
		
		// 7.0.0 以上
		else {
			$type = 1;
		}
		
		// 6.4.0 以上の時
		if ($type === 1) {
			return str_replace('-js', '" async data-site="' . $blogId, $tag);
		}
		
		// 6.4.0 未満の時
		else {
			return str_replace('-js', "' async data-site='" . $blogId, $tag);
		}
		
	}
	
}

